
//clouds

float4x4	view_proj_matrix	:	register(c0);
float4x4	C8					:	register(c8);
float4x4	view_matrix			:	register(c20);
float4		C41					:	register(c41);
float4		C50					:	register(c50);
float4		C55					:	register(c55);
float4		C56					:	register(c56);
float4		C59					:	register(c59);
float4		C60					:	register(c60);
float4		C61					:	register(c61);
float4		C62					:	register(c62);
float4		C63					:	register(c63);
float4		C64					:	register(c64);
float4		C65					:	register(c65);
float4		C66					:	register(c66);

float4		carPos				:	register(c103);


texture		textureA;

sampler2D samplerA = sampler_state
{
    Texture		= (textureA);  
    AddressU	= WRAP;
    AddressV	= WRAP;  

	MinFilter	= LINEAR;
	MagFilter	= LINEAR;
	MipFilter	= NONE;
};


struct VS_IN
{
	float4 Pos			:	POSITION;
	float4 diffuse		:	COLOR0;
	float4 diffuseAUV	:	TEXCOORD0;
};


struct VS_OUT
{
	float4	Pos			: POSITION;
	float	Fog			: FOG;
	float4  diffuseA	: COLOR0;
	float4  diffuseB	: COLOR1;
	float4  diffuseAUV	: TEXCOORD0;
	float4	psPos		: TEXCOORD1;
	float	dist		: TEXCOORD2;
};


VS_OUT CloudsVS(VS_IN In)
{
	VS_OUT Out		= (VS_OUT)0;

	Out.Pos = mul(view_proj_matrix, float4(In.Pos.xyz, 1));

	Out.diffuseAUV	= In.diffuseAUV;
	Out.psPos		= In.Pos;
	Out.dist = length(carPos - In.Pos);


	float4 R10 = mul(In.Pos, C8);
	float4 R1 = normalize(C50 - R10);
	float4 R0 = float4(0,0,0,0);
	R0.x = dot(R1, C41);

	R0.x = min(R0.x, C64.x);
	R0.y = R0.x * R0.x + C64.x;

	R1 = mul(R10, view_matrix);
	R0.z = R1.z * C66.x;

	R1 = C61 * (-R0.z);
	R1 *= C64.y;

	R1.x		= pow(2,R1.x);
	R1.y		= pow(2,R1.y);
	R1.z		= pow(2,R1.z);

	float4 R3 = R1 * C56;
	R3 = R3 * C65.x;

	float4 R4  = float4(0,0,0,0);
	R4.x = C63.x * R0.x + C63.y;

	R4.x = rsqrt(R4.x);
	R4.y = R4.x * R4.x;
	R4.x = R4.x * R4.y;
	R0.w = R4.x * C63.x;

	R4 = C59 * R0.y;
	float4 R5 = C60 * R0.w;
	float4 R6 = float4(0,0,0,0);
	R6 = C64.x - R1;


	R4 += R5;
	R4 *= R6;
	R4 *= C62;
	R4 *= C65.y;
	R4 *= C55;
	R4 *= C55.w;
	R3 *= C55;
	R3 *= C55.w;

	Out.diffuseA	= In.diffuse * R3;
	Out.diffuseA.w  = In.diffuse.w;
	Out.diffuseB	= R4;

	return Out;
}



float4 CloudsPS(VS_OUT IN) : COLOR
{
	float4	outColor	= float4(0,0,0,0);
	float4 texcolorA	= tex2D(samplerA, IN.diffuseAUV);
	outColor.xyz		= saturate(texcolorA * IN.diffuseA);
	outColor.w			= saturate(IN.diffuseA.w * IN.diffuseA.w * texcolorA.w);
	outColor.xyz		= saturate(outColor + IN.diffuseB);
	//outColor.xyz		= saturate(pow(outColor.xyz, 8) + outColor.xyz * 0.5);
	//outColor.w			= (outColor.w * outColor.w + outColor.w);
	return  outColor;
}
 
technique Clouds
{
	pass p0
	{
		FillMode = SOLID;

		Lighting = FALSE;
		Clipping = FALSE;
		CullMode = NONE;
		
		FogEnable	= FALSE;
		FogColor	= 0x00000000;
		FogDensity	= 1.0f;
		FogEnd		= 10000.0f;
		FogStart	= 50.0f;

		//Pixel Pipe Render States
		AlphaBlendEnable	= TRUE;
		AlphaRef			= 0;
		AlphaTestEnable		= FALSE;
		AlphaFunc			= GREATER;	
					
		ZEnable				= TRUE;
		ZWriteEnable		= FALSE;
		ZFunc				= LESSEQUAL;

		SrcBlend			= SRCALPHA;
		DestBlend			= INVSRCALPHA;

		Sampler[0] = (samplerA);
		VertexShader	= compile vs_2_0 CloudsVS();
		PixelShader		= compile ps_2_0 CloudsPS();
	}
}